/* Copyright (c) 2004, 2012, Oracle and/or its affiliates. 
All rights reserved. */

/*

   NAME
     odbcconnect.c - Simple ODBC Connect demo

   DESCRIPTION
     Basic ODBC Connect demo
     Connects to db and retrieves db version

   EXPORT FUNCTION(S)
     <external functions defined for use outside package - one-line description>

   INTERNAL FUNCTION(S)
     <other external functions defined - one-line descriptions>

   STATIC FUNCTION(S)
     <static functions defined - one-line descriptions>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
   sudsrini    09/20/12 - Error Handling for SQLGetInfo
   sprabhak    08/16/05 - Set ODBC Version Info
   ardesai     03/04/05 - Include windows.h for windows platform.
   subanerj    06/06/04 - subanerj_odbc_env_setup
   ardesai     06/02/04 - Creation

*/

#ifdef WIN32COMMON
#include <windows.h>
#endif

#include <stdio.h>
#include <sql.h>
#include <sqlext.h>

#define STR_LEN 50

int main (int argc, char *argv[])
{
  HENV          henv;               /* environment handle */
  HDBC          hdbc;               /* connection handle */
  HSTMT         hstmt;              /* statement handle */
  SDWORD        retcode;            /* return code */
  UCHAR         info[STR_LEN];      /* info string for SQLGetInfo */
  SQLSMALLINT   cbInfoValue;
  SQLCHAR       SqlState[6], Msg[SQL_MAX_MESSAGE_LENGTH];
  SQLINTEGER    NativeError;
  SQLSMALLINT   MsgLen;

  retcode = SQLAllocEnv (&henv);
  retcode = SQLSetEnvAttr (henv, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3,
              SQL_IS_INTEGER);
  retcode = SQLAllocConnect (henv, &hdbc);
  retcode = SQLConnect (hdbc, "TestDBDSN", SQL_NTS, "scott", SQL_NTS, "tiger",
              SQL_NTS);

  if (retcode != SQL_SUCCESS)
  {
    if ((retcode = SQLGetDiagRec (SQL_HANDLE_DBC, hdbc, 1, SqlState, 
                   &NativeError, Msg, sizeof(Msg), &MsgLen)) != SQL_NO_DATA)
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
    goto EXIT;
  }

  retcode = SQLGetInfo (hdbc, SQL_DBMS_VER, &info, STR_LEN, &cbInfoValue);

  if (retcode != SQL_SUCCESS)
  {
    if ((retcode = SQLGetDiagRec (SQL_HANDLE_DBC, hdbc, 1, SqlState, 
                   &NativeError, Msg, sizeof(Msg), &MsgLen)) != SQL_NO_DATA)
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
    goto EXIT;
  }

  printf ("Current DBMS version is %s\n", info);

EXIT:
  SQLDisconnect (hdbc);
  SQLFreeConnect (hdbc);
  SQLFreeEnv (henv);
  return 0;
}


/* end of file connect.c */
